/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.bpa.fru;

import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementException;
import com.ibm.hwmca.fw.service.panel.GenericGui;
import com.ibm.hwmca.fw.service.panel.TextAndRadiobuttonGroupDataBean;
import com.ibm.hwmca.fw.service.panel.TextGraphicAndRadiobuttonGroupDataBean;
import com.ibm.hwmca.fw.service.statetransition.Context;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.service.bpa.panel.PBBPAConfirmPowerOff;
import com.ibm.hwmca.p.service.bpa.panel.PBBPAPowerOff;
import com.ibm.hwmca.xfw.service.PETrace;
import com.ibm.hwmca.xfw.service.SD;
import com.ibm.hwmca.xfw.service.bpa.panel.PBBPACheckFrontLeds10;
import com.ibm.hwmca.xfw.service.bpa.panel.PBBPACheckRearLeds10;
import com.ibm.hwmca.xfw.service.bpa.panel.PBBPAConfirmContinue;
import com.ibm.hwmca.xfw.service.managedsystem.fru.BpaResidentFru;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultBpaFru;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFru;
import com.ibm.hwmca.xfw.service.managedsystem.fru.GenericBpaFru;
import java.util.Map;

public abstract class PIDefaultBpaFru
extends DefaultFru
implements GenericBpaFru {
    protected static final String TRACE_MASKT = "XRVPBPAT";
    protected static final String TRACE_MASKF = "XRVPBPAF";
    protected static final String TRACE_MASKD = "XRVPBPAD";
    protected DefaultBpaFru bpaFruImpl = new DefaultBpaFru();

    public String getPowerDomain(Map userData) throws ServiceableElementException {
        return (String)this.getProperty("LOCATION");
    }

    public void displayServiceEffect(Map userData) throws ServiceableElementException {
        Trace.trace(TRACE_MASKT, "-> PIDefaultBpaFru.displayServiceEffect");
        String sFruLocationCode = (String)this.getProperties().get("LOCATION");
        int locStartIndex = sFruLocationCode.indexOf(45) + 1;
        int locEndIndex = sFruLocationCode.length();
        String sShortLocation = sFruLocationCode.substring(locStartIndex, locEndIndex);
        Trace.trace(TRACE_MASKF, "    FRU location is: " + sFruLocationCode);
        Trace.trace(TRACE_MASKF, "    Short FRU location is: " + sShortLocation);
        boolean bDone = false;
        while (!bDone) {
            String strServiceEffectResult;
            try {
                if (this.hardwareInterface != null && !(this.hardwareInterface instanceof DefaultFru.DummyServiceableElementMaintenance)) {
                    this.hardwareInterface = null;
                }
                PETrace.petrace(userData, "Testing redundancy status for power FRU location: " + this.getProperty("LOCATION"));
                strServiceEffectResult = this.getHardwareInterface(userData).getServiceEffect(sFruLocationCode);
                PETrace.petrace(userData, "Redundancy status: " + strServiceEffectResult);
            }
            catch (Exception e) {
                this.hardwareInterface = new DefaultFru.DummyServiceableElementMaintenance();
                strServiceEffectResult = "UNKNOWN";
                PETrace.petrace(userData, "**BPA HARDWARE INTERFACE COULD NOT BE ESTABLISHED** The user is given option to continue with power off.");
            }
            this.setRedundancyStatus(strServiceEffectResult);
            if (strServiceEffectResult.equals("REDUNDANT") || strServiceEffectResult.equals(SD.DELAY)) {
                bDone = true;
                if (this instanceof BpaResidentFru) {
                    if (strServiceEffectResult.equals("REDUNDANT")) {
                        TextGraphicAndRadiobuttonGroupDataBean ledBean;
                        GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                        try {
                            ledBean = this.isFront(sShortLocation) ? new PBBPACheckRearLeds10() : new PBBPACheckFrontLeds10();
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKT, "<-! PIDefaultBpaFru.displayServiceEffect exception caught: " + e);
                            Trace.trace(TRACE_MASKT, e);
                            throw new ServiceableElementException(e);
                        }
                        ledBean.disablePreviousButton();
                        ledBean = (TextGraphicAndRadiobuttonGroupDataBean)this.setCommonSubs(ledBean);
                        try {
                            ledBean = (TextGraphicAndRadiobuttonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", ledBean.getTemplateName(), ledBean, userData);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKT, "<-! guiHandle.replace exception caught: " + e);
                            Trace.trace(TRACE_MASKT, e);
                            throw new ServiceableElementException(e);
                        }
                        if (ledBean.isFirstRadioButtonSelected()) {
                            bDone = true;
                            TextAndRadiobuttonGroupDataBean continueBean = new PBBPAConfirmContinue();
                            continueBean.disablePreviousButton();
                            continueBean = (TextAndRadiobuttonGroupDataBean)this.setCommonSubs(continueBean);
                            try {
                                continueBean = (TextAndRadiobuttonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", continueBean.getTemplateName(), continueBean, userData);
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKT, "<-! guiHandle.replace exception caught: " + e);
                                Trace.trace(TRACE_MASKT, e);
                                throw new ServiceableElementException(e);
                            }
                            if (!continueBean.isFirstRadioButtonSelected()) {
                                strServiceEffectResult = SD.DELAY;
                                this.setRedundancyStatus(SD.DELAY);
                                try {
                                    Context context = (Context)userData.get("STS_CONTEXT");
                                    context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.DELAY);
                                    context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                                }
                                catch (Exception e) {
                                    Trace.trace(TRACE_MASKT, "!!! PIDefaultBpaFru.displayServiceEffect exception caught setting OVERALL_STATUS to DELAY: " + e);
                                    Trace.trace(TRACE_MASKT, e);
                                    throw new ServiceableElementException("exception caught setting OVERALL_STATUS to DELAY: " + e);
                                }
                            }
                        } else {
                            bDone = false;
                            strServiceEffectResult = "NOT_REDUNDANT";
                            this.setRedundancyStatus(strServiceEffectResult);
                        }
                    }
                }
            }
            if (!strServiceEffectResult.equals("NOT_REDUNDANT")) {
                if (!strServiceEffectResult.equals("UNKNOWN")) continue;
            }
            boolean bConfirmDone = false;
            while (!bConfirmDone) {
                GenericGui guiHandle = (GenericGui)userData.get("DISPLAY_HANDLE");
                TextAndRadiobuttonGroupDataBean powerOffBean = new PBBPAPowerOff();
                powerOffBean.disablePreviousButton();
                powerOffBean = (TextAndRadiobuttonGroupDataBean)this.setCommonSubs(powerOffBean);
                powerOffBean.getDataMap().put("REDUNDANCY_STATUS", strServiceEffectResult);
                try {
                    powerOffBean = (TextAndRadiobuttonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", powerOffBean.getTemplateName(), powerOffBean, userData);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! guiHandle.replace exception caught: " + e);
                    Trace.trace(TRACE_MASKT, e);
                    throw new ServiceableElementException(e);
                }
                if (powerOffBean.isFirstRadioButtonSelected()) {
                    TextAndRadiobuttonGroupDataBean confirmBean = new PBBPAConfirmPowerOff();
                    confirmBean.disablePreviousButton();
                    confirmBean = (TextAndRadiobuttonGroupDataBean)this.setCommonSubs(confirmBean);
                    try {
                        confirmBean = (TextAndRadiobuttonGroupDataBean)guiHandle.replace("com.ibm.hwmca.fw.service.panel.res.CommonPanels", confirmBean.getTemplateName(), confirmBean, userData);
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKT, "<-! guiHandle.replace exception caught: " + e);
                        Trace.trace(TRACE_MASKT, e);
                        throw new ServiceableElementException(e);
                    }
                    if (confirmBean.isFirstRadioButtonSelected()) {
                        bConfirmDone = true;
                        bDone = true;
                        this.setRedundancyStatus("REDUNDANT_POWER_OFF");
                        continue;
                    }
                    bConfirmDone = false;
                    continue;
                }
                strServiceEffectResult = SD.DELAY;
                this.setRedundancyStatus(SD.DELAY);
                bConfirmDone = true;
                bDone = true;
                try {
                    Context context = (Context)userData.get("STS_CONTEXT");
                    context.getVariable(SD.USER_SELECTION_VARIABLE).setValue(SD.DELAY);
                    context.getVariable(SD.OVERALL_STATUS_VARIABLE).setValue(SD.DELAY);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-! PIDefaultBpaFru.displayServiceEffect exception caught setting OVERALL_STATUS to DELAY: " + e);
                    Trace.trace(TRACE_MASKT, e);
                    throw new ServiceableElementException("exception caught setting OVERALL_STATUS to DELAY: " + e);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PIDefaultBpaFru.displayServiceEffect");
    }

    private boolean isFront(String sLocation) throws ServiceableElementException {
        Trace.trace(TRACE_MASKF, "  isFront::FRU location is: " + sLocation);
        if (sLocation.equals("A1") || sLocation.startsWith("P1")) {
            return true;
        }
        if (sLocation.equals("A2") || sLocation.startsWith("P2")) {
            return false;
        }
        throw new ServiceableElementException("Location not valid for isFront()");
    }

    public String getRedundancyStatus() {
        return this.bpaFruImpl.getRedundancyStatus();
    }

    public void setRedundancyStatus(String fruRedundancyStatus) {
        this.bpaFruImpl.setRedundancyStatus(fruRedundancyStatus);
    }

    public synchronized String getSide() {
        String location;
        int dash;
        if (this.bpaFruImpl.getSide().equals("UNKNOWN") && (dash = (location = (String)this.getProperties().get("LOCATION")).indexOf(45)) != -1) {
            String suffix = location.substring(dash + 1);
            if (suffix.indexOf(50) == 1) {
                this.bpaFruImpl.setSide("SIDE_B");
            } else {
                this.bpaFruImpl.setSide("SIDE_A");
            }
        }
        return this.bpaFruImpl.getSide();
    }

    public synchronized void setSide(String fruSide) {
        this.bpaFruImpl.setSide(fruSide);
    }
}

